using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class LayoutUtils
{
    // ----------------------------------------------------------------------------------------
    public static RectTransform DrawDot(Vector3 position, Transform transform)
    {
        GameObject newDot = new GameObject();
        newDot.transform.SetParent(transform);
        newDot.transform.localScale = new Vector3(0.2f, 0.2f, 0.2f);
		newDot.layer = 5;

		RectTransform rectTransform = newDot.AddComponent<RectTransform>();
        Image image = newDot.AddComponent<Image>();
        image.color = Color.white;
        //image.sprite = Interface.Instance.dotSelection;

        rectTransform.sizeDelta = new Vector2(180f, 180f);
        rectTransform.pivot = new Vector2(0.5f, 0.5f);

        position.z = -1.0f; // transform.localPosition.z - 0.09f;
        rectTransform.localPosition = position; // + (Vector3)shape.Page.LocalPosition;

        return rectTransform;
    }

    // --------------------------------------------------------------------------------------------	

    public static LineRenderer DrawDottedLine(Transform[] pts, Transform parent, bool loop = false)
    {
        GameObject newLine = new GameObject();
        newLine.transform.SetParent(parent);
        newLine.transform.localScale = Vector3.one;
        newLine.transform.localPosition = Vector3.zero;
        newLine.transform.localRotation = Quaternion.identity;
        newLine.layer = 5;

		newLine.name = "Line";

        LineRenderer lineRenderer = newLine.AddComponent<LineRenderer>();

        //lineRenderer.colorGradient = Color.red;


        lineRenderer.textureMode = LineTextureMode.Tile;

        lineRenderer.alignment = LineAlignment.View;
        lineRenderer.startWidth = 0.05f;
        lineRenderer.endWidth = 0.05f;
        lineRenderer.useWorldSpace = false;
        lineRenderer.loop = loop;
        lineRenderer.numCornerVertices = 8;

        Vector3[] positions = new Vector3[pts.Length];

        lineRenderer.positionCount = pts.Length;

        float defaultZ = -0.09f; // transform.localPosition.z - 0.09f;

        float dist = 0;
        for (int i = 0; i < pts.Length; i++)
        {
            if (i > 0) dist += (pts[i].localPosition - pts[i - 1].localPosition).magnitude;
            positions[i] = pts[i].localPosition;
            positions[i].z = defaultZ;
        }

        //lineRenderer.material = new Material(Interface.Instance.dottedMaterial)
        //{
        //    mainTextureScale = new Vector2(3.0f /*dist * 3.0f / 2.0f*/, 1.0f)
        //};

        lineRenderer.SetPositions(positions);

        return lineRenderer;
    }

	// --------------------------------------------------------------------------------------------	

	public static LineRenderer DrawDottedLineVoid(Transform parent, bool loop = false)
	{
		GameObject newLine = new GameObject();
		newLine.transform.SetParent(parent);
		newLine.transform.localScale = Vector3.one;
		newLine.transform.localPosition = Vector3.zero;
		newLine.transform.localRotation = Quaternion.identity;

		newLine.name = "Line";

		LineRenderer lineRenderer = newLine.AddComponent<LineRenderer>();

		//lineRenderer.colorGradient = Color.red;


		lineRenderer.textureMode = LineTextureMode.Tile;

		lineRenderer.alignment = LineAlignment.View;
		lineRenderer.startWidth = 0.05f;
		lineRenderer.endWidth = 0.05f;
		lineRenderer.useWorldSpace = true;
		lineRenderer.loop = loop;
		lineRenderer.numCornerVertices = 8;

		//lineRenderer.material = new Material(Interface.Instance.dottedMaterial)
		//{
		//	mainTextureScale = new Vector2(3.0f /*dist * 3.0f / 2.0f*/, 1.0f)
		//};

		return lineRenderer;
	}

	// --------------------------------------------------------------------------------------------	
	public static GameObject DrawDottedSelection(Transform from, Transform to, Transform parent = null)
    {
        GameObject newLine = new GameObject();
        newLine.transform.SetParent(parent);
        newLine.transform.localScale = Vector3.one;

        RectTransform rectTransform = newLine.AddComponent<RectTransform>();
        UnityEngine.UI.Image image = newLine.AddComponent<UnityEngine.UI.Image>();
        image.color = Color.white;
        //image.sprite = Interface.Instance.lineSelection;
        image.type = UnityEngine.UI.Image.Type.Tiled;

        Vector3 differenceVector = from.localPosition - to.localPosition;
        rectTransform.sizeDelta = new Vector2(differenceVector.magnitude, 24.0f);
        rectTransform.pivot = new Vector2(0, 0.5f);

        rectTransform.position = from.position;
        float angle = Mathf.Atan2(differenceVector.y, differenceVector.x) * Mathf.Rad2Deg;
        rectTransform.localRotation = Quaternion.Euler(0, 0, angle + 180.0f);

        return newLine;
    }
}
